%% Nicolas Lamaison, Can Kocabalkanli: AX=XB Solver for Hand-Eye Calibration

% Calculates the relative transformation between the optical end effector and tool "X"
% Based on Assignment 2 - Function axxb for ASBR Fall 2019 by Nicolas Lamaison
function [X] = axxb(A1, B1)

% Defining constants
N = size(A1, 3); %%


e_bh = A1(1:3,4,:);
e_sc = B1(1:3,4,:);
% Throwing error in case user doesn't provide enough data points
if N < 3
    error('Please provide at least 3 data points for hand-eye calibration')
end

% Defining matrices to store relative rotations A and B, alpha and beta vectors
A = zeros(4, 4, N);
B = zeros(4, 4, N); 
tA = zeros(3, N);
tB = zeros(3, N);
alphas = zeros(3, N);
betas = zeros(3, N);

% Converting quaternions of e_bh and e_sc to rotation matrices
rot_bh = A1(1:3,1:3,:);%quat2rotm([e_bh(:, 7) e_bh(:, 4:6)]);
rot_sc = B1(1:3,1:3,:);%quat2rotm([e_sc(:, 7) e_sc(:, 4:6)]);

% Reference transformations
%E_bh_0 = [rot_bh(:, :, N) e_bh(N, 1:3)'; 0 0 0 1];
E_bh_0 = [rot_bh(:, :, N) e_bh(:,:,N); 0 0 0 1];
E_sc_0 = [rot_sc(:, :, N) e_sc(:,:,N); 0 0 0 1];

% Generating relative rotation matrices A and B 
for i = 1:N

    % Transformations used to find A and B
    E_bh_current = [rot_bh(:, :, i) e_bh(:,:,i); 0 0 0 1];
    E_sc_current = [rot_sc(:, :, i) e_sc(:,:,i); 0 0 0 1];

    % Finding relative transformations A and B
    A(:, :, i) = E_bh_0 \ E_bh_current;
    B(:, :, i) = E_sc_0 / E_sc_current;
    
    A(:, :, i) = E_bh_current;
    B(:, :, i) = E_sc_current;

    % Collecting translation parts of A and B
    tA(:, i) = A(1:3, 4, i);
    tB(:, i) = B(1:3, 4, i);

end

% Collecting rotation parts of A and B
RA = A(1:3, 1:3, :);
RB = B(1:3, 1:3, :);

% Collecting skew vectors corresponding to RA and RB matrices
for i = 1:N

    alphas(:, i) = skew2vec(logm(RA(:, :, i)));
    betas(:, i) = skew2vec(logm(RB(:, :, i)));

end

% Solving for the rotational component of the transformation X
Rx = solveRx(alphas, betas);

% Solving for the translational component of the transformation X
tx = solveTx(RA, tA, RB, tB, Rx);

% Combining rotation and translation parts to construct X
X = [Rx tx; 0 0 0 1];

